unit UFigury;

interface

Uses
   Windows, Classes, Graphics;

Type

Figura = class(TObject)
private
	kolor  : TColor;
   brush	 : TBrush;
   font	 : TFont;
   pen	 : TPen;

protected
   Canvas : TCanvas;	// tylko wskanik, nie usuwa

public
	procedure   Show();	virtual; abstract;
   constructor Create(parCanvas : TCanvas); virtual;
   destructor  Destroy(); override;
end;


Prostokat = class(Figura)
private
   x1	: Integer;
   y1	: Integer;
   x2	: Integer;
   y2	: Integer;
   R  : TRect;

public
	procedure   Show(); override;

   constructor Create(parCanvas : TCanvas; parR : TRect); overload;
   constructor Create(parCanvas : TCanvas; parX1, parY1, parX2, parY2 : Integer); overload;
   destructor  Destroy(); override;
end;

Kolo = class(Figura)
private
   x1	: Integer;
   y1	: Integer;
   x2	: Integer;
   y2	: Integer;
   R  : TRect;

public
	procedure   Show(); override;

   constructor Create(parCanvas : TCanvas; parR : TRect); overload;
   constructor Create(parCanvas : TCanvas; parX1, parY1, parX2, parY2 : Integer); overload;
   destructor  Destroy(); override;
end;

Trojkat = class(Figura)
private
   x1	: Integer;
   y1	: Integer;
   x2	: Integer;
   y2	: Integer;
   R  : TRect;

public
	procedure   Show(); override;

   constructor Create(parCanvas : TCanvas; parR : TRect); overload;
   constructor Create(parCanvas : TCanvas; parX1, parY1, parX2, parY2 : Integer); overload;
   destructor  Destroy(); override;
end;

implementation

constructor Figura.Create(parCanvas: TCanvas);
begin
	Canvas := parCanvas;
end;

destructor Figura.Destroy();
begin
	inherited;
end;

constructor Prostokat.Create(parCanvas: TCanvas; parR: TRect);
begin
	inherited Create(parCanvas);

   R := parR;

   x1 := parR.Left;
   y1 := parR.Top;
   x2 := parR.Right;
   y2 := parR.Bottom;
end;

constructor Prostokat.Create(parCanvas : TCanvas; parX1, parY1, parX2, parY2 : Integer);
begin
	inherited Create(parCanvas);

   R := Rect(parX1, parY1, parX2, parY2);

   x1 := R.Left;
   y1 := R.Top;
   x2 := R.Right;
   y2 := R.Bottom;
end;

destructor Prostokat.Destroy();
begin
	inherited;
end;

procedure Prostokat.Show();
begin
   Canvas.Rectangle(x1, y1, x2, y2);
end;

constructor Kolo.Create(parCanvas: TCanvas; parR: TRect);
begin
	inherited Create(parCanvas);

   R := parR;

   x1 := parR.Left;
   y1 := parR.Top;
   x2 := parR.Right;
   y2 := parR.Bottom;
end;

constructor Kolo.Create(parCanvas: TCanvas; parX1, parY1, parX2, parY2: Integer);
begin
	inherited Create(parCanvas);

   R := Rect(parX1, parY1, parX2, parY2);

   x1 := R.Left;
   y1 := R.Top;
   x2 := R.Right;
   y2 := R.Bottom;
end;

destructor Kolo.Destroy();
begin
	inherited;
end;

procedure Kolo.Show();
begin
	Canvas.Ellipse(x1, y1, x2, y2);
end;

constructor Trojkat.Create(parCanvas: TCanvas; parR: TRect);
begin
	inherited Create(parCanvas);

   R := parR;

   x1 := parR.Left;
   y1 := parR.Top;
   x2 := parR.Right;
   y2 := parR.Bottom;
end;

constructor Trojkat.Create(parCanvas: TCanvas; parX1, parY1, parX2, parY2: Integer);
begin
	inherited Create(parCanvas);

   R := Rect(parX1, parY1, parX2, parY2);

   x1 := R.Left;
   y1 := R.Top;
   x2 := R.Right;
   y2 := R.Bottom;
end;

destructor Trojkat.Destroy();
begin
	inherited;
end;

procedure Trojkat.Show();
var
	srodek_x : Integer;

begin
	srodek_x := 0;

   srodek_x := (x2 - x1);
   srodek_x := srodek_x div 2;
   srodek_x := x1 + srodek_x;

   // rysuje od dou w prawo do gry
   Canvas.MoveTo(x1, y2);
   Canvas.LineTo(x2, y2);
   Canvas.LineTo(srodek_x, y1);
   Canvas.LineTo(x1, y2);
end;

end.

